import matplotlib.pyplot as plt

def mean(lst):
    return sum(lst) / len(lst)

def uniform_errors():
    perfect_rm = [0.37, 0.37, 0.37, 0.37, 0.37, 0.37, 0.37, 0.37]

    ind_belief_0 = [0.37, 0.37, 0.37, 0.37, 0.37, 0.37, 0.37, 0.37]
    ind_belief_0_5 = [0, 0, 0, 0, -0.16, 0, 0.35, 0.37]
    ind_belief_1 = [0, 0, 0, 0, 0, 0, 0, 0]
    ind_belief_1_5 = [0, 0, 0, 0, 0, 0, 0, 0]
    ind_belief_2 = [0, 0, 0, 0, 0, 0, 0, 0]

    ind_belief_plus_0 = [0.37, 0.37, 0.37, 0.37, 0.37, 0.36, 0.37, 0.37]
    ind_belief_plus_0_5 = [0.35, 0.37, 0.37, 0.37, 0.36, 0.37, 0.37, 0.36]
    ind_belief_plus_1 = [0.36, 0.35, 0.35, 0.37, 0.35, 0.36, 0.37, 0.37]
    ind_belief_plus_1_5 = [0, -0.09, 0.35, 0, 0, 0.35, -0.05, 0]
    ind_belief_plus_2 = [0, 0, 0, 0, 0, 0, 0, 0]

    belief_thresholding_0 = [0.37, 0.37, 0.37, 0.37, 0.37, 0.37, 0.37, 0.37]
    belief_thresholding_0_5 = [0.37, 0.37, 0.37, 0.36, 0.37, 0.37, 0.37, 0.37]
    belief_thresholding_1 = [0.37, 0.37, 0.37, 0.37, 0.37, 0.37, 0.37, 0.37]
    belief_thresholding_1_5 = [0.37, 0.37, 0.37, 0.37, 0.37, 0.37, 0.37, 0.37]
    belief_thresholding_2 = [0, -0.1, 0.37, 0.37, 0.37, 0, -0.14, 0]

    xs = [0, 0.5, 1, 1.5, 2]
    plt.title("Mining Uniform Errors")
    plt.ylabel("(Test) Discounted Return")
    plt.xlabel("ε")
    plt.plot(xs, [mean(perfect_rm)] * 5, marker='o', label="Perfect RM", linestyle='dashed')
    plt.plot(xs, [mean(ind_belief_0), mean(ind_belief_0_5), mean(ind_belief_1), mean(ind_belief_1_5), mean(ind_belief_2)], marker='o', label="Independent Belief Updating")
    plt.plot(xs, [mean(ind_belief_plus_0), mean(ind_belief_plus_0_5), mean(ind_belief_plus_1), mean(ind_belief_plus_1_5), mean(ind_belief_plus_2)], marker='o', label="Belief Updating")
    plt.plot(xs, [mean(belief_thresholding_0), mean(belief_thresholding_0_5), mean(belief_thresholding_1), mean(belief_thresholding_1_5), mean(belief_thresholding_2)], marker='o', label="Event Thresholding")
    plt.legend()
    plt.show()

def fp_errors():
    perfect_rm = [0.37, 0.37, 0.37, 0.37, 0.37, 0.37, 0.37, 0.37]

    ind_belief_0 = [0.37, 0.36, 0.37, 0.36, 0.37, 0.37, 0.37, 0.37]
    ind_belief_0_5 = [0.37, 0.37, 0.37, 0.37, 0.37, 0.37, -0.05, 0.37]
    ind_belief_1 = [-0.18, 0, 0.37, 0, 0, -0.1, 0, 0.37]
    ind_belief_1_25 = [0.35, 0, -0.18, 0.35, 0, 0, 0.35, 0]
    ind_belief_1_5 = [0, 0, 0, 0, 0, 0, 0, 0]

    ind_belief_plus_0 = [0.37, 0.37, 0.37, 0.37, 0.37, 0.37, 0.37, 0.37]
    ind_belief_plus_0_5 = [0.37, 0.37, 0.37, 0.37, 0.35, 0.37, 0.37, 0.37]
    ind_belief_plus_1 = [0.35, 0.35, 0.37, 0.37, 0.37, 0.37, 0.35, 0.35]
    ind_belief_plus_1_25 = [0.35, 0.37, 0.37, 0.35, 0.37, 0.35, 0.36, -0.14]
    ind_belief_plus_1_5 = [0, -0.19, 0, 0, 0, -0.19, 0, 0]

    belief_thresholding_0 = [0.37, 0.37, 0.37, 0.37, 0.37, 0.37, 0.37, 0.37]
    belief_thresholding_0_5 = [0.37, 0.37, 0.37, 0.37, 0.37, 0.37, 0.37, 0.36]
    belief_thresholding_1 = [0, 0, 0, -0.05, 0, -0.1, -0.1, 0]
    belief_thresholding_1_25 = [0, -0.05, 0, 0, 0, 0, -0.19, 0]
    belief_thresholding_1_5 = [0, 0, 0, 0, 0, 0, 0, 0]

    xs = [0, 0.5, 1, 1.25, 1.5]
    plt.title("Mining False Positive Errors")
    plt.ylabel("(Test) Discounted Return")
    plt.xlabel("ε")
    plt.plot(xs, [mean(perfect_rm)] * 5, marker='o', linestyle='dashed', label="Perfect RM")
    plt.plot(xs, [mean(ind_belief_0), mean(ind_belief_0_5), mean(ind_belief_1), mean(ind_belief_1_25), mean(ind_belief_1_5)], marker='o', label="Independent Belief Updating")
    plt.plot(xs, [mean(ind_belief_plus_0), mean(ind_belief_plus_0_5), mean(ind_belief_plus_1), mean(ind_belief_plus_1_25), mean(ind_belief_plus_1_5)], marker='o', label="Belief Updating")
    plt.plot(xs, [mean(belief_thresholding_0), mean(belief_thresholding_0_5), mean(belief_thresholding_1), mean(belief_thresholding_1_25), mean(belief_thresholding_1_5)], marker='o', label="Event Thresholding")
    plt.legend()
    plt.show()



uniform_errors()


